# Quiz3 API Documentation

**Base URL:** `https://quiz3.snaplimit.com/user/`

## Important Notes

- **All requests and responses are encrypted** using a custom encryption algorithm (Base64 + Vowel Replacement)
- Request body must be encrypted before sending
- Response body must be decrypted after receiving
- Most endpoints require `Device-ID` header
- Authenticated endpoints require `Session-Token` header

### Encryption Helper

To encrypt a JSON payload before sending:
```php
// Example encryption function (see token_encryption.php)
$json = json_encode($data);
$encrypted = encryptToken($json);
```

To decrypt a response:
```php
// Example decryption function
$decrypted = decryptToken($response);
$data = json_decode($decrypted, true);
```

---

## Authentication Endpoints

### 1. Account (Login/Signup)

**Endpoint:** `POST /user/account`

**Description:** Handles user login and signup with "one device, one account" policy.

**Headers:**
```
Device-ID: <device_id> (required)
```

**Request Body (Encrypted JSON):**
```json
{
  "email": "user@example.com",
  "device_id": "device_unique_id_12345",
  "refercode": "REF1234" (optional, for signup)
}
```

**Curl Example:**
```bash
curl -X POST https://quiz3.snaplimit.com/user/account \
  -H "Device-ID: device_unique_id_12345" \
  -H "Content-Type: application/json" \
  -d "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "Login successful",
  "data": {
    "user_id": 1,
    "email": "user@example.com",
    "refercode": "user1234",
    "coins": 0,
    "can_claim": true
  },
  "new_session_token": "strong_session_token_64_chars"
}
```

**Error Responses:**
- `400`: Missing or empty field, Device already used, Email already registered
- `429`: Too many requests
- `500`: Database connection failed

---

### 2. Logout

**Endpoint:** `POST /user/logout`

**Description:** Logs out the user by deleting their session token.

**Headers:**
```
Device-ID: <device_id> (required)
Session-Token: <session_token> (required)
```

**Request Body (Encrypted JSON):**
```json
{
  "user_id": 1
}
```

**Curl Example:**
```bash
curl -X POST https://quiz3.snaplimit.com/user/logout \
  -H "Device-ID: device_unique_id_12345" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "Logout successful"
}
```

---

## App Settings & Configuration

### 3. App Settings

**Endpoint:** `POST /user/app_settings`

**Description:** Fetches app settings (public or authenticated).

**Headers:**
```
Device-ID: <device_id> (optional for public action)
Session-Token: <session_token> (required for user_blocked action)
```

**Request Body (Encrypted JSON):**
```json
{
  "action": "public" (or "user_blocked")
}
```

**For authenticated request:**
```json
{
  "action": "user_blocked",
  "user_id": 1
}
```

**Curl Example (Public):**
```bash
curl -X POST https://quiz3.snaplimit.com/user/app_settings \
  -H "Content-Type: application/json" \
  -d "<encrypted_payload>"
```

**Curl Example (Authenticated):**
```bash
curl -X POST https://quiz3.snaplimit.com/user/app_settings \
  -H "Device-ID: device_unique_id_12345" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "App settings fetched",
  "data": {
    "update": {
      "app_link": "https://play.google.com/store/apps/details?id=...",
      "app_base_url": "https://quizpop.playexplore.in/beta_api/user/",
      "version": "3.0",
      "version_code": 2,
      "changelogs": "..."
    },
    "maintenance": 0,
    "vpn_allowed": 1,
    "guest_mode": 1,
    "earning_mode": 1,
    "gamezop_timer": 5,
    "gamezop_card_status": 1,
    "ad_app_size": 30,
    "update_mode": "off",
    "ads_settings": {
      "app_id": "ca-app-pub-...",
      "interstitial_ad_unit": "/21775744923/example/interstitial",
      "native_ad_unit": "/21775744923/example/native-video",
      "banner_ad_unit": "/21775744923/example/adaptive-banner",
      "reward_ad_unit": "/21775744923/example/rewarded",
      "appopen_ad_unit": "/21775744923/example/app-open"
    },
    "ad_controls": [...],
    "links": {
      "how_to": "https://www.youtube.com/",
      "telegram": "https://t.me/earnbitofficial",
      "support": "https://t.me/earnbitofficial",
      "privacy_policy": "https://quizpopapp.blogspot.com/...",
      "delete_account": "https://docs.google.com/forms/..."
    }
  }
}
```

---

### 4. Home

**Endpoint:** `POST /user/home`

**Description:** Fetches home screen data (public or authenticated).

**Headers:**
```
Device-ID: <device_id> (optional for public)
Session-Token: <session_token> (required for auth action)
```

**Request Body (Encrypted JSON):**
```json
{
  "action": "public" (or "auth")
}
```

**For authenticated request:**
```json
{
  "action": "auth",
  "user_id": 1
}
```

**Curl Example:**
```bash
curl -X POST https://quiz3.snaplimit.com/user/home \
  -H "Device-ID: device_unique_id_12345" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "Home data fetched",
  "data": {
    "maintenance": 0,
    "vpn_allowed": 1,
    "guest_mode": 1,
    "earning_mode": 1,
    "gamezop_timer": 5,
    "ad_index": null,
    "gamezop_card_status": 1,
    "ad_app_size": 30,
    "ad_controls": [...],
    "user_coins": 1000,
    "daily_checkin": {
      "can_claim": true
    },
    "links": {
      "how_to": "https://www.youtube.com/",
      "telegram": "https://t.me/earnbitofficial",
      "support": "https://t.me/earnbitofficial"
    }
  },
  "new_session_token": "new_session_token_here"
}
```

---

### 5. Utility (Status Check)

**Endpoint:** `POST /user/utility`

**Description:** Fetches app settings, links, and user block status.

**Headers:**
```
Device-ID: <device_id> (required)
Session-Token: <session_token> (required)
```

**Request Body (Encrypted JSON):**
```json
{
  "user_id": 1,
  "action": "check_status"
}
```

**Curl Example:**
```bash
curl -X POST https://quiz3.snaplimit.com/user/utility \
  -H "Device-ID: device_unique_id_12345" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "Status fetched",
  "data": {
    "update": {
      "app_link": "https://play.google.com/store/apps/...",
      "version": "3.0",
      "version_code": 2,
      "changelogs": "..."
    },
    "maintenance": 0,
    "vpn_allowed": 1,
    "is_blocked": 0,
    "links": {
      "how_to": "https://www.youtube.com/",
      "telegram": "https://t.me/earnbitofficial",
      "support": "https://t.me/earnbitofficial"
    }
  },
  "new_session_token": "new_session_token_here"
}
```

---

## Task Endpoints

### 6. Task Questions

**Endpoint:** `POST /user/task_questions`

**Description:** Fetches questions for a specific task type.

**Headers:**
```
Device-ID: <device_id> (required)
Session-Token: <session_token> (required)
```

**Request Body (Encrypted JSON):**
```json
{
  "task_type": "number_game" (or "guess_alphabet", "fruit_finder", "logo_quiz"),
  "limit": 10 (optional, default 10, max 50)
}
```

**Curl Example:**
```bash
curl -X POST https://quiz3.snaplimit.com/user/task_questions \
  -H "Device-ID: device_unique_id_12345" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "Questions fetched",
  "data": {
    "questions": [
      {
        "id": 1,
        "task_type": "number_game",
        "question": "What is the largest number from below list?",
        "options": ["62", "65", "60", "68"],
        "correct_answer": "68"
      }
    ],
    "reward_coins": "10-20"
  }
}
```

**Error Responses:**
- `400`: Invalid task_type, Invalid limit, No questions found
- `401`: Unauthorized
- `429`: Too many requests

---

### 7. Task Limits

**Endpoint:** `POST /user/task_limits`

**Description:** Fetches task limits and usage information.

**Headers:**
```
Device-ID: <device_id> (required)
Session-Token: <session_token> (required)
```

**Request Body (Encrypted JSON):**
```json
{
  "user_id": 1,
  "task_type": "number_game" (optional, if not provided returns all tasks)
}
```

**Curl Example:**
```bash
curl -X POST https://quiz3.snaplimit.com/user/task_limits \
  -H "Device-ID: device_unique_id_12345" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "Task limits fetched",
  "data": {
    "enabled": true,
    "earning_mode": 1,
    "vpn_allowed": 1,
    "native_ad_load_refresh_count": 5,
    "coins": 1000,
    "limits": [
      {
        "task_type": "number_game",
        "daily_limit": 5,
        "used_count": 2,
        "remaining_limit": 3,
        "reward_coins": 15,
        "ad_index": 2,
        "important_ad_type": "inter"
      }
    ],
    "ad_index": [2]
  },
  "new_session_token": "new_session_token_here"
}
```

---

### 8. Complete Task

**Endpoint:** `POST /user/complete_task`

**Description:** Marks a task as complete without updating coins (used for checking limits).

**Headers:**
```
Device-ID: <device_id> (required)
Session-Token: <session_token> (required)
```

**Request Body (Encrypted JSON):**
```json
{
  "user_id": 1,
  "earned_coins": 10,
  "by_task": "number_game",
  "created_at": "2025-10-14 12:00:00" (optional)
}
```

**Curl Example:**
```bash
curl -X POST https://quiz3.snaplimit.com/user/complete_task \
  -H "Device-ID: device_unique_id_12345" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "Task completed",
  "data": {
    "show_ad": true,
    "claim_timer": 30,
    "total_coins": 1000,
    "task_limits": {
      "enabled": true,
      "remaining_limit": 3,
      "daily_limit": 5
    },
    "referral_reward": {
      "awarded": false
    }
  },
  "new_session_token": "new_session_token_here"
}
```

---

### 9. Final Submit

**Endpoint:** `POST /user/final_submit`

**Description:** Final submission that updates user coins after task completion.

**Headers:**
```
Device-ID: <device_id> (required)
Session-Token: <session_token> (required)
```

**Request Body (Encrypted JSON):**
```json
{
  "user_id": 1,
  "earned_coins": 15,
  "by_task": "number_game",
  "created_at": "2025-10-14 12:00:00" (optional)
}
```

**Curl Example:**
```bash
curl -X POST https://quiz3.snaplimit.com/user/final_submit \
  -H "Device-ID: device_unique_id_12345" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "Final submission completed successfully",
  "data": {
    "total_coins": 1015,
    "earned_coins": 15,
    "limits": [
      [
        ["daily_limit", 5],
        ["remaining_limit", 2],
        ["task_type", "number_game"],
        ["used_count", 3]
      ]
    ]
  },
  "new_session_token": "new_session_token_here"
}
```

---

## Daily Check-in Endpoints

### 10. Check-in Status

**Endpoint:** `POST /user/checkin_status`

**Description:** Checks daily check-in status for the user.

**Headers:**
```
Device-ID: <device_id> (required)
Session-Token: <session_token> (required)
```

**Request Body (Encrypted JSON):**
```json
{
  "user_id": 1
}
```

**Curl Example:**
```bash
curl -X POST https://quiz3.snaplimit.com/user/checkin_status \
  -H "Device-ID: device_unique_id_12345" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "Checkin status fetched",
  "data": {
    "can_claim": true,
    "coins_reward": 50,
    "last_claimed": "2025-10-13 10:30:00",
    "next_available": "2025-10-15 00:00:00",
    "streak_days": 3
  },
  "new_session_token": "new_session_token_here"
}
```

---

### 11. Daily Check-in

**Endpoint:** `POST /user/daily_checkin`

**Description:** Claims daily check-in coins.

**Headers:**
```
Device-ID: <device_id> (required)
Session-Token: <session_token> (required)
```

**Request Body (Encrypted JSON):**
```json
{
  "user_id": 1,
  "earned_coins": 50 (optional, if not provided uses app settings default)
}
```

**Curl Example:**
```bash
curl -X POST https://quiz3.snaplimit.com/user/daily_checkin \
  -H "Device-ID: device_unique_id_12345" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "Daily checkin claimed successfully",
  "data": {
    "coins_earned": 50,
    "total_coins": 1050,
    "next_checkin_available": "2025-10-16 00:00:00"
  },
  "new_session_token": "new_session_token_here"
}
```

**Error Responses:**
- `400`: Already claimed today
- `401`: Unauthorized
- `429`: Too many requests

---

## Referral & Promo Code Endpoints

### 12. Apply Referral Code

**Endpoint:** `POST /user/apply_refercode`

**Description:** Applies a referral code to the user account.

**Headers:**
```
Device-ID: <device_id> (required)
Session-Token: <session_token> (required)
```

**Request Body (Encrypted JSON):**
```json
{
  "user_id": 1,
  "refercode": "REF1234"
}
```

**Curl Example:**
```bash
curl -X POST https://quiz3.snaplimit.com/user/apply_refercode \
  -H "Device-ID: device_unique_id_12345" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "Referral code applied successfully",
  "data": {
    "message": "Referral code applied successfully! You will receive your referral reward after your first successful redeem."
  },
  "new_session_token": "new_session_token_here"
}
```

**Error Responses:**
- `400`: Invalid referral code, Already used a referral code, Cannot use own code
- `401`: Unauthorized
- `429`: Too many requests

---

### 13. Apply Promo Code

**Endpoint:** `POST /user/promocode`

**Description:** Applies a promo code to award coins.

**Headers:**
```
Device-ID: <device_id> (required)
Session-Token: <session_token> (required)
```

**Request Body (Encrypted JSON):**
```json
{
  "user_id": 1,
  "code": "WELCOME"
}
```

**Curl Example:**
```bash
curl -X POST https://quiz3.snaplimit.com/user/promocode \
  -H "Device-ID: device_unique_id_12345" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "Promo code applied",
  "data": {
    "coins_awarded": 50,
    "coins": 1050
  },
  "new_session_token": "new_session_token_here"
}
```

**Error Responses:**
- `400`: Invalid promo code, Expired, Usage limit reached, Already used
- `401`: Unauthorized
- `429`: Too many requests

---

## Redeem Endpoints

### 14. Redeem

**Endpoint:** `POST /user/redeem`

**Description:** Redeems coins for gift cards/vouchers. Supports multiple actions.

**Headers:**
```
Device-ID: <device_id> (required)
Session-Token: <session_token> (required)
```

**Request Body (Encrypted JSON):**

**Action: List Categories**
```json
{
  "user_id": 1,
  "action": "list_categories"
}
```

**Action: List Subcategories**
```json
{
  "user_id": 1,
  "action": "list_subcategories",
  "category_id": 1,
  "sub_category_name": "Google Play" (optional, for filtering)
}
```

**Action: Redeem**
```json
{
  "user_id": 1,
  "action": "redeem",
  "subcategory_id": 40
}
```

**Curl Example (List Categories):**
```bash
curl -X POST https://quiz3.snaplimit.com/user/redeem \
  -H "Device-ID: device_unique_id_12345" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d "<encrypted_payload>"
```

**Success Response - List Categories (200):**
```json
{
  "status": 200,
  "message": "Categories fetched",
  "data": {
    "categories": [
      {
        "category_id": 1,
        "category_name": "Google Gift Card",
        "category_image_url": "https://snaplimit.com/Assets/google_play_card.png"
      }
    ]
  },
  "new_session_token": "new_session_token_here"
}
```

**Success Response - List Subcategories (200):**
```json
{
  "status": 200,
  "message": "Subcategories fetched",
  "data": {
    "subcategories": [
      {
        "id": 40,
        "sub_category_name": "google play gift",
        "sub_category_image_url": "https://snaplimit.com/Assets/playstore.png",
        "coins": 800,
        "cash": 10.00,
        "is_enabled": 1
      }
    ]
  },
  "new_session_token": "new_session_token_here"
}
```

**Success Response - Redeem (200):**
```json
{
  "status": 200,
  "message": "Redeem request successful",
  "data": {
    "coins": 200,
    "gift_code": "GOOG-800-QRST",
    "created_at": "14/10/2025 12:00 PM"
  },
  "new_session_token": "new_session_token_here"
}
```

**Error Responses:**
- `400`: Invalid subcategory, Insufficient coins, Daily withdraw limit reached, Complete all daily tasks first
- `401`: Unauthorized
- `429`: Too many requests

---

### 15. Redeem History

**Endpoint:** `POST /user/redeem_history`

**Description:** Fetches redemption history for the user.

**Headers:**
```
Device-ID: <device_id> (required)
Session-Token: <session_token> (required)
```

**Request Body (Encrypted JSON):**
```json
{
  "user_id": 1
}
```

**Curl Example:**
```bash
curl -X POST https://quiz3.snaplimit.com/user/redeem_history \
  -H "Device-ID: device_unique_id_12345" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "Redeem history fetched",
  "data": {
    "history": [
      {
        "id": 64,
        "redeem_option_name": "Google Gift Card - google play gift",
        "image_url": "https://snaplimit.com/Assets/playstore.png",
        "gift_code": "GOOG-800-QRST",
        "pin": null,
        "status": "approved",
        "rejection_reason": null,
        "cash": 10.00,
        "created_at": "11/07/2025 05:31 PM"
      }
    ]
  },
  "new_session_token": "new_session_token_here"
}
```

---

## Gamezop API

### 16. Gamezop API Proxy

**Endpoint:** `GET /user/gamezop_api`

**Description:** Proxy endpoint for Gamezop game API.

**Query Parameters:**
- `action`: search, category, tag, all, list-categories, list-tags, game-details
- `query`: Search query (for search action)
- `name`: Category name (for category action)
- `tag`: Tag name (for tag action)
- `code`: Game code (for game-details action)

**Curl Example:**
```bash
curl -X GET "https://quiz3.snaplimit.com/user/gamezop_api?action=all" \
  -H "Content-Type: application/json"
```

**Success Response (200):**
```json
{
  "games": [
    {
      "code": "SJX7TGkDq1X",
      "name": {"en": "Game Name"},
      "description": {"en": "Game Description"},
      "categories": {"en": ["Puzzle & Logic"]},
      "tags": {"en": ["arcade", "puzzle"]}
    }
  ]
}
```

---

## Account Management

### 17. Delete Account

**Endpoint:** `POST /user/delete_account`

**Description:** Deletes user account and all associated data.

**Headers:**
```
Device-ID: <device_id> (required)
Session-Token: <session_token> (required)
```

**Request Body (Encrypted JSON):**
```json
{
  "user_id": 1
}
```

**Curl Example:**
```bash
curl -X POST https://quiz3.snaplimit.com/user/delete_account \
  -H "Device-ID: device_unique_id_12345" \
  -H "Session-Token: your_session_token_here" \
  -H "Content-Type: application/json" \
  -d "<encrypted_payload>"
```

**Success Response (200):**
```json
{
  "status": 200,
  "message": "Account deleted successfully"
}
```

---

## Task Types

The following task types are available:

- `number_game` - Number Game (formerly math_fact)
- `guess_alphabet` - Guess Alphabet (formerly alphabet_guess)
- `fruit_finder` - Fruit Finder (formerly colour_guess)
- `logo_quiz` - Logo Quiz (formerly vehicle_guess)

---

## Error Codes

- `200`: Success
- `400`: Bad Request (Invalid input, missing fields, validation errors)
- `401`: Unauthorized (Invalid session token)
- `405`: Method Not Allowed
- `429`: Too Many Requests (Rate limit exceeded)
- `500`: Internal Server Error (Database connection failed, server error)

---

## Rate Limiting

- Rate limiting is applied per user
- Default limit: 100 requests per hour (configurable in app_settings)
- Rate limit applies to authenticated endpoints
- Unauthenticated endpoints use a separate rate limit (user_id = 0)

---

## Session Management

- Session tokens are valid for 30 days
- Each request may return a new session token in `new_session_token` field
- Always use the latest session token for subsequent requests
- Session tokens are device-specific (Device-ID + Session-Token combination)

---

## Notes

1. All timestamps are in `Asia/Kolkata` timezone
2. All dates in responses use format: `YYYY-MM-DD HH:MM:SS`
3. Coin values are integers
4. Task limits can be ranges (e.g., "5-10") which are randomized per user
5. Daily check-in resets at midnight (00:00:00) IST
6. Task usage limits reset daily at midnight IST

---

## Example: Complete Flow

1. **Sign up/Login:**
```bash
curl -X POST https://quiz3.snaplimit.com/user/account \
  -H "Device-ID: device123" \
  -d "<encrypted: {\"email\":\"user@example.com\",\"device_id\":\"device123\"}>"
```

2. **Get App Settings:**
```bash
curl -X POST https://quiz3.snaplimit.com/user/app_settings \
  -d "<encrypted: {\"action\":\"public\"}>"
```

3. **Get Task Questions:**
```bash
curl -X POST https://quiz3.snaplimit.com/user/task_questions \
  -H "Device-ID: device123" \
  -H "Session-Token: token_from_step1" \
  -d "<encrypted: {\"task_type\":\"number_game\",\"limit\":10}>"
```

4. **Complete Task:**
```bash
curl -X POST https://quiz3.snaplimit.com/user/complete_task \
  -H "Device-ID: device123" \
  -H "Session-Token: token_from_step1" \
  -d "<encrypted: {\"user_id\":1,\"earned_coins\":15,\"by_task\":\"number_game\"}>"
```

5. **Final Submit:**
```bash
curl -X POST https://quiz3.snaplimit.com/user/final_submit \
  -H "Device-ID: device123" \
  -H "Session-Token: token_from_step1" \
  -d "<encrypted: {\"user_id\":1,\"earned_coins\":15,\"by_task\":\"number_game\"}>"
```

---

**Document Version:** 1.0  
**Last Updated:** October 2025  
**Base URL:** `https://quiz3.snaplimit.com/user/`

